/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridLayout;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class GetID {
    private static void printinet(NetworkInterface ni) {
        Enumeration<InetAddress> e = ni.getInetAddresses();
        while (e.hasMoreElements()) {
            InetAddress ia = e.nextElement();
            System.out.println(ia.getHostAddress());
        }
    }

    public static void main(String[] args) {
        try {
            String s = "";
            String si = "";
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            si = si + "NETWORK INTERFACES:\n";
            si = si + "-----------------------------------------------------------\n";
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                byte[] addr = ni.getHardwareAddress();
                System.out.println(ni);
                GetID.printinet(ni);
                String hexId = "";
                if (ni.isVirtual() || ni.isLoopback() || ni.isPointToPoint() || addr == null || addr.length == 0 || ni.getDisplayName() == null || ni.getDisplayName().toLowerCase().contains("virtual")) continue;
                if (s.length() != 0) {
                    s = s + ",";
                }
                hexId = HexEncoder.encode(addr).toLowerCase();
                s = s + hexId;
                si = si + ni.getName() + ":" + hexId + ":" + ni.getDisplayName() + "\n";
            }
            si = si + "\n";
            si = si + "-----------------------------------------------------------\n";
            si = si + "OS ARCHITECTURE: " + System.getProperty("os.arch") + "\n";
            si = si + "OS NAME:         " + System.getProperty("os.name") + "\n";
            si = si + "VM NAME:         " + System.getProperty("java.vm.name") + "\n";
            si = si + "JAVA VERSION:    " + System.getProperty("java.version") + "\n";
            System.out.println("");
            System.out.println("HARDWARE ID:" + s);
            System.out.println("-----------------------------------------------------------\n");
            System.out.println(si);
            JTextField t = new JTextField(s);
            t.setEditable(false);
            JLabel label1 = new JLabel("Hardware ID:");
            JLabel label2 = new JLabel("Additional Information:");
            JTextArea ta = new JTextArea(si);
            ta.setAutoscrolls(true);
            JFrame frame = new JFrame("Celoxis License Application");
            frame.setDefaultCloseOperation(3);
            JPanel p = new JPanel(new GridLayout(1, 2));
            p.add(label1);
            p.add(t);
            p.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            frame.setContentPane(p);
            frame.setSize(200, 80);
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class HexEncoder {
        private static final char[] codes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

        private boolean arraysAreEqual(byte[] array1, byte[] array2) {
            if (array1.length != array2.length) {
                return false;
            }
            int len = array1.length;
            for (int i = 0; i < len; ++i) {
                if (array1[i] == array2[i]) continue;
                return false;
            }
            return true;
        }

        private static int convertToNumber(char inChar) {
            if (inChar >= '0' && inChar <= '9') {
                return inChar - 48;
            }
            if (inChar >= 'A' && inChar <= 'F') {
                return inChar - 65 + 10;
            }
            if (inChar >= 'a' && inChar <= 'f') {
                return inChar - 97 + 10;
            }
            return -1;
        }

        public static byte[] decode(String inputData) throws IllegalArgumentException {
            String myName = "decode";
            if (inputData == null) {
                throw new IllegalArgumentException(myName + " inputData must not be null");
            }
            int len = inputData.length();
            if (len == 0) {
                throw new IllegalArgumentException(myName + " inputData must be of length > 0");
            }
            if (len % 2 != 0) {
                throw new IllegalArgumentException(myName + " inputData must be of even length");
            }
            byte[] finalResult = new byte[len / 2];
            int arrayPos = 0;
            for (int i = 0; i < len; ++i) {
                int temp = HexEncoder.convertToNumber(inputData.charAt(i));
                if (temp < 0) {
                    throw new IllegalArgumentException(myName + " illegal hex character in input Data: " + inputData);
                }
                if (i % 2 == 1) {
                    byte temp2 = (byte)(finalResult[arrayPos] << 4);
                    finalResult[arrayPos] = (byte)(temp2 | (byte)temp);
                    ++arrayPos;
                    continue;
                }
                finalResult[arrayPos] = (byte)temp;
            }
            return finalResult;
        }

        public static String encode(byte[] inputData) throws IllegalArgumentException {
            String myName = "encode(byte)";
            int len = inputData.length;
            if (len == 0) {
                throw new IllegalArgumentException("encode(byte) inputData must be of length > 0");
            }
            StringBuffer buffer = new StringBuffer(len * 2);
            for (int i = 0; i < len; ++i) {
                int a = inputData[i];
                if (a < 0) {
                    a &= 0xFF;
                }
                buffer.append(codes[a >>>= 4]);
                buffer.append(codes[inputData[i] & 0xF]);
            }
            return buffer.toString();
        }

        public String encode(String s) throws IllegalArgumentException {
            return HexEncoder.encode(s.getBytes());
        }
    }
}

